/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Pwm_ReportError.h
  \brief    	This file contains all Pwm Report Error functions as well as \n
              all Error Type definitions.
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	4/14/2008 12:12:30 PM
  \warning    DO NOT MODIFY THE NAME OF ERROR TYPES. USER IS ABLE TO CHANGE THEIR VALUES\n
              BUT NOT THEIR NAMES.
  * History:
  
*/
#ifndef PWM_REPORT_ERROR_H
  #define PWM_REPORT_ERROR_H

/** Include Definitions from PWM Configuration file */
#include "Pwm_Cfg.h"
/*----------------------------- Definitions ----------------------------*/
/** API Error Types */
#define PWM_INIT_ID               ((uint8_t)0x00)
#define PWM_SETDUTYCYCLE_ID       ((uint8_t)0x01)
#define PWM_SETPERIODANDDUTY_ID   ((uint8_t)0x02)
#define PWM_SETOUTPUTTOIDLE_ID    ((uint8_t)0x03)
#define PWM_CALLBACK_PTR_ID       ((uint8_t)0x04)

/** PWM Error Types */
#define PWM_E_PARAM_CONFIG        ((uint8_t)0x10)
#define PWM_E_UNINIT              ((uint8_t)0x11)
#define PWM_E_PARAM_CHANNEL       ((uint8_t)0x12)
#define PWM_E_DUTYCYCLE_RANGE     ((uint8_t)0x13) 
#define PWM_E_PERIOD_DUTY_RANGE   ((uint8_t)0x14)
#define PWM_E_FNC_CALLBACK_UNINIT ((uint8_t)0x15)

/*----------------------------- Functions ------------------------------*/
  #if (PWM_ERROR_DETECT == ON)
     void vfnPwm_Report_Error(uint8_t ApiId, uint8_t ErrorId);
  #endif
#endif